tokage = {};

tokage.NAME_AREA = "#name_area";
tokage.TEXT_AREA = "#text_area";
tokage.NEXT_DIV  = "#next_div";
tokage.LAYERS = 10;
tokage.CHAR_TIME = 20;
tokage.BR_TIME = 100;
tokage.SAVEDATA_NUM = 5;
tokage.CANVAS_TAG = "tokage_canvas"; // #を付けない

tokage.loadScript = function(sav, storage)
{
	var storageFull = "./data/scenario_" + sav.lang + "/" + storage;
	
	// storageから同期通信で読み込む
	sav.script = $.ajax( { url : storageFull, async : false } ).responseText;

	// ラベルをタグに変換
	sav.script = sav.script.replace(/^\s*(\*[a-zA-Z0-9_]+)\s*$/gm, "[label name=$1]");
	
	// キャラクター名をタグに変換
	sav.script = sav.script.replace(/^\s*\#([a-zA-Z0-9_]+):([a-zA-Z0-9_]+)\s*$/gm, "[chara_act name=$1 face=$2]");
	sav.script = sav.script.replace(/^\s*\#\s*$/gm, "[chara_act]"); // 名前欄を空にするやつ
	sav.script = sav.script.replace(/^\s*\#([a-zA-Z0-9_]*)\s*$/gm, "[chara_act name=\"$1\"]");
	
	// [lr][lcm]
	// メモ：第一引数は正規表現にしないと最初の１個しか置き換えてくれないらしい
	sav.script = sav.script.replace(/\[lr\]/g, "[l][r]");
	sav.script = sav.script.replace(/\[lcm\]/g, "[l][cm]");
	
	// メモ：コメントや通常文字も前処理しようと検討したが
	// 正規表現では難しいことが判明し、
	// コメント判定のために改行も残すことになった
	
	// メモ：アットマーク形式の変換も厳しいので
	// []形式しか対応しないことにした
	
	sav.pointer = 0;
	
	// console.log(sav.script);
};

// すっ飛ばすかどうかも考慮してタグを実行する
// 【戻り値】休憩時間または無期限休止を表す-1
tokage.executeOrNot = function(ram, sav, tagName, o, callback)
{
	if (ram.searchingLabel == null)
	{
		return tokage.tag.process(ram, sav, tagName, o, callback);
	}
	
	// searchingLabelが設定されている場合は、
	// それと等しい[label]タグを見つけるまで他のタグを実行しない
	else
	{
		if (tagName === "label" && o.name === ram.searchingLabel)
		{
			ram.searchingLabel = null;
		}
		return 0;
	}
};

// 1文字処理する
// 【戻り値】休憩時間または無期限休止を表す-1
tokage.processChar = function(ram, sav, callback)
{
	var c = sav.script.charAt(sav.pointer);
	var msDelay = 0;
	var execute = false; // 最後に実行するフラグ
	
	// 末尾まで行った
	if (c === "")
	{
		if (ram.searchingLabel != null)
		{
			console.log("ERROR: ラベル(" + ram.searchingLabel + ")が見つかりませんでした");
		}
		return -1;
	}
	
	switch(ram.state)
	{
	case 0: // 通常文字
		if (c === " " || c === "\t") { }
		else if (c === "\n") { }
		else if (c === "[") { ram.tagName = ""; ram.params = {}; ram.state = 2; }
		else if (c === ";") { ram.state = 99; }
		else
		{
			ram.tagName = "put";
			ram.params = { text : c };
			execute = true;
		}
		break;
		
	case 2: // タグ名
		if (c === " " || c === "\t") { ram.state = 3; }
		else if (c === "]")
		{
			ram.state = 0;
			execute = true;
		}
		else { ram.tagName += c; }
		break;
		
	case 3: // タグ名後または引数後の空白
		if (c === " " || c === "\t") { }
		else if (c === "]") // ※ややグレーな書式にも対応する
		{
			ram.state = 0;
			execute = true;
		}
		else { ram.paramName = c; ram.state = 4; }
		break;

	case 4: // 引数名
		if (c === " " || c === "\t") { } // ※出来れば止めて欲しい書式
		else if (c === "=") { ram.state = 5; }
		else { ram.paramName += c; }
		break;
		
	case 5: // 引数名後のイコール
		if (c === " " || c === "\t") { }
		else if (c === "\"") { ram.param = ""; ram.doubleQuote =  true; ram.state = 6; }
		else                 { ram.param =  c; ram.doubleQuote = false; ram.state = 6; }
		break;

	case 6: // 引数
		if (ram.doubleQuote)
		{
			if (c === "\\") { ram.escapeSequence = true; }
			else if (c === "\"" && !ram.escapeSequence)
			{
				ram.params[ram.paramName] = ram.param;
				ram.doubleQuote = false;
				ram.state = 3;
			}
			else { ram.param += c; ram.escapeSequence = false; }
		}
		else
		{
			if (c === " " || c === "\t")
			{
				ram.params[ram.paramName] = ram.param;
				ram.state = 3;
			}
			else if (c === "]")
			{
				ram.params[ram.paramName] = ram.param;
				ram.state = 0;
				execute = true;
			}
			else { ram.param += c; }
		}
		break;
		
	case 99: // コメント
		if (c === "\n") { ram.state = 0; }
		break;
	
	default:
		msDelay = -1;
		break;
	}
	
	sav.pointer++;
	
	// 必ず、ポインタ－を加算してからタグを実行する
	// 理由は、以下の様に意図しない文字出力が起こりうるため
	// 1. [trans]実行(time=すごく小さい) (スレッド1)
	// 2. [trans]によってloop()が呼び出される (スレッド2) ──想定外の早さ──
	// 3. スレッド2で１文字読み込まれ、[put]として出力される
	//    (スレッド1でsav.pointer++されていないので、transの閉じ大括弧が読み込まれる)
	// 4. スレッド1と2で２回sav.pointer++される→結果、大括弧直後の文字が無視されてしまう
	
	if (execute)
	{
		msDelay = tokage.executeOrNot(ram, sav, ram.tagName, ram.params, callback);
	}
	
	return msDelay;
};





